<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Kuesioner;
use App\KuesionerJawabanPeserta;
use App\PertanyaanKuesioner;
use App\OpsiPertanyaan;
use Tymon\JWTAuth\Facades\JWTAuth;
class KuesionerController extends ResponseController
{
    //
     public function createKuesioner(Request $request){
            $arr = array (
                array(
                    "name" => "Pankaj Singh",
                    "age" => "20"
                ),
                array(
                    "name" => "Arun Yadav",
                    "age" => "21"
                ),
                array(
                    "name" => "Apeksha Jaiswal",
                    "age" => "20"
                )
            );
            $jsonArr = json_encode($arr);

            return $this->successResponse(200,$jsonArr);
        }
        public function testGetKuesioner(Request $request){
            $res = $request->data;
            return $this->successResponse(200,$res);
        }

        public function getKuesioner(){
            $kuesioner  = Kuesioner::all();
            return $this->successResponse(200,$kuesioner);
        }
        public function getPertanyaanKuesioner($idKuesioner){
             $listPertanyaan = PertanyaanKuesioner::where('deleted','=',0)
        ->where('kuesioner_id','=',$idKuesioner)->get();
        $data = array();
        for($i = 0; $i < count($listPertanyaan); $i++){
            $pertanyaan = $listPertanyaan[$i];
            if($pertanyaan->tipe_opsi == 'R' || $pertanyaan->tipe_opsi == 'C' ){
                $opsi = OpsiPertanyaan::where('kuesioner_pertanyaan_id','=',$pertanyaan->kuesioner_pertanyaan_id)->get([
                    'no_opsi',
                    'ket_opsi'
                ]);
                // $json = json_decode($pertanyaan);
                $pertanyaan['opsi'] = $opsi;
                $json_string = json_encode($pertanyaan);
                $arr = json_decode($json_string);
                array_push($data,$arr);
            }else{
                array_push($data,$pertanyaan);
            }
        }
        return $this->successResponse(200,$data);
        }
        public function getKuesionerWajib(){
            $user = JWTAuth::parseToken()->authenticate();
            $idLogin  = $user->user_id;
            $listKuesioner = Kuesioner::where('wajib','=',1)->get();
            $kuesionerWajib = array();
            
            for($i = 0; $i < count($listKuesioner); $i++){
                $kuesioner = $listKuesioner[$i];
            
                $cekJawaban = KuesionerJawabanPeserta::where('user_id', '=' , $idLogin)
                ->where('kuesioner_id','=',$kuesioner->kuesioner_id)->get();

                // return $this->successResponse(200,count($cekJawaban));
                if(count($cekJawaban) == 0){
                    array_push($kuesionerWajib,$kuesioner);
                }
            }

            return $this->successResponse(200,$kuesionerWajib);
        }

        public function sendKuesioner(Request $request){
            $data = $request->kuesioner;
        // $arr = array();
            foreach($data  as $datum){
                $datas = json_encode($datum);
                $arr = json_decode($datas);
                $jawabanKuesioner = new KuesionerJawabanPeserta();
                $jawabanKuesioner->kuesioner_id = $arr->kuesioner_id;
                $jawabanKuesioner->kuesioner_pertanyaan_id = $arr->kuesioner_pertanyaan_id;
                $jawabanKuesioner->jawaban = $arr->jawaban;
                $jawabanKuesioner->peserta = $arr->peserta;
                $jawabanKuesioner->user_id = $arr->user_id;
                $jawabanKuesioner->created_at = date('Y-m-d H:i:s');
                $jawabanKuesioner->created_by = $arr->peserta;
                $jawabanKuesioner->updated_by = $arr->peserta;
                $jawabanKuesioner->save();
            }
            return $this->successResponse(200,$data);
        }
}
